package gov.va.vinci.dart.db.util;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class CallableStatementDAO<T> extends HibernateDAO {
	public CallableStatementDAO() {}
	
	public abstract String getQueryText();
	public abstract void populateParameters(final CallableStatement cstmt) throws SQLException;
	public abstract T buildResult(final ResultSet rs) throws SQLException;
	
	public List<T> build() throws SQLException {
		
		List<T> result = new ArrayList<T>();
		
		CallableStatement cstmt = createCallableStatement(getQueryText());
		populateParameters(cstmt);
	
		ResultSet rs = cstmt.executeQuery();
		
		if( rs != null ) {
			
			while (rs.next()) {
				result.add(buildResult(rs));
			}
		}
		
		return result;
	}
}
